import pandas as pd
from datetime import datetime, timedelta
from matplotlib import pyplot as plt
from matplotlib import dates as mpl_dates

plt.style.use("seaborn")

data = pd.read_csv("bitcoin_prices.csv")
# dates are read as strings, we need to fix it
#price_date = data["Date"]

data["Date"] = pd.to_datetime(data["Date"])
#sort date by date time in place to modify the original data set
data.sort_values("Date", inplace=True)

price_date = data["Date"]
open_prices = data["Open"]
low_prices = data["Low"]
high_prices = data["High"]
closing_prices = data["Close"]
adj_closing = data["Adj Close"]
volume = data["Volume"]

labels = ["Open price","Low price", "High price", "Closing price", "Adjusted closing price"]

plt.plot_date(price_date, open_prices, linestyle='solid', label="Open prices")
plt.plot_date(price_date, low_prices, linestyle='solid', label="Low prices")
plt.gcf().autofmt_xdate()

# date formatting - datetime.strftime or mpl_dates
date_format = mpl_dates.DateFormatter('%d. %b %Y')
plt.gca().xaxis.set_major_formatter(date_format)


plt.title("Bitcoin prices")
plt.xlabel("Date")
plt.ylabel("Prices")

plt.legend()

plt.tight_layout()
plt.show()